private import std.file, std.stream;

/* Get a list  of exports from an OMF file. */
char [] [] omfListExports (char [] filename)
{
    Stream stream = new File (filename);
    char [] [] list;
    char [] [] lnames;

    ubyte igetub () { ubyte value; stream.read (value); return value; }
    ushort igetuw () { ubyte [2] value; stream.read (value); return value [0] | (value [1] << 8); }
    ushort igetud () { ubyte [4] value; stream.read (value); return value [0] | (value [1] << 8) | (value [2] << 16) | (value [3] << 24); }

    ushort readIndex()
    {
        ubyte value = igetub();

        if (value < 128)
            return value;
        return ((value & 127) * 128) | igetub();
    }

    char[] readString()
    {
        ubyte length = igetub();
        ubyte[] data = new ubyte[length];

        stream.read(data);
        for (int c; c < data.length; c ++)
            assert(data[c] < 128);
        return cast (char[]) data;
    }

    while (1)
    {
        ubyte type = igetub ();
        ushort length = igetuw ();
        int recordEnd = stream.position () + length - 1;

        switch (type)
        {
            case 0x8A:
                delete stream;
                return list;

            case 0x96: /* LNAMES */
                while (stream.position () < recordEnd)
                    lnames ~= readString ();
                break;

            case 0xC2: /* COMDAT */
            case 0xC3:
            {
                bit big = (type == 0xC3);
                ubyte flags = igetub ();
                ubyte attribs = igetub ();
                ubyte alignment = igetub ();
                uint offset = (big ? igetud () : igetuw ());
                ushort typeIndex = readIndex ();
                ushort group = readIndex ();
                int segmentIndex = readIndex () - 1;
                uint size;
                char [] name = lnames [readIndex () - 1];

                list ~= name;
                break;
            }
                
            default:
                break;
        }

        stream.seekSet (recordEnd + 1);
    }
}
